-- **************************************************
-- ██████  ██████   █████  ██    ██ ███████ ███    ██ 
-- ██   ██ ██   ██ ██   ██ ██    ██ ██      ████   ██ 
-- ██████  ██████  ███████ ██    ██ █████   ██ ██  ██ 
-- ██   ██ ██   ██ ██   ██  ██  ██  ██      ██  ██ ██ 
-- ██████  ██   ██ ██   ██   ████   ███████ ██   ████
-- **************************************************

-- Credits for this function: Konijima
local delayFunction = function(func, delay)

    delay = delay or 1
    local ticks = 0
    local canceled = false

    local function onTick()

        if not canceled and ticks < delay then
            ticks = ticks + 1
            return
        end

        Events.OnTick.Remove(onTick)
        if not canceled then func() end
    end

    Events.OnTick.Add(onTick)
    return function()
        canceled = true
    end
end

local fetchSquaresAroundStairs = function(playerObj, playerSquare, stairsDir)

    local tileType = nil
    for i = 0,playerSquare:getObjects():size()-1 do
        local v = playerSquare:getObjects():get(i)
        if v then
            tileType = v:getType():toString()
        end
    end

    if not tileType then return end

    local range = 3
    if tileType == "stairsMN" or tileType == "stairsMW"  then range = 2 end
    if tileType == "stairsTN" or tileType == "stairsTW"  then range = 1 end

    local cell = getCell()
    local squareList = {}
    local indicatorList = {}

    local playerX = playerSquare:getX()
    local playerY = playerSquare:getY()
    local playerZ = playerSquare:getZ()

    for i = 0, range do
        if stairsDir == "North" then
            local sqCenter = cell:getGridSquare(playerX, playerY - i, playerZ + 1)
            if sqCenter then table.insert(squareList, sqCenter) end

            local sqLeft = cell:getGridSquare(playerX - 1, playerY - i, playerZ + 1)
            if sqLeft then table.insert(squareList, sqLeft) end

            local sqRight = cell:getGridSquare(playerX + 1, playerY - i, playerZ + 1)
            if sqRight then table.insert(squareList, sqRight) end
        else
            local sqCenter = cell:getGridSquare(playerX - i, playerY, playerZ + 1)
            if sqCenter then table.insert(squareList, sqCenter) end

            local sqLeft = cell:getGridSquare(playerX - i, playerY - 1, playerZ + 1)
            if sqLeft then table.insert(squareList, sqLeft) end

            local sqRight = cell:getGridSquare(playerX - i, playerY + 1, playerZ + 1)
            if sqRight then table.insert(squareList, sqRight) end
        end
    end

    local zombieNum = 0

    for _, sq in pairs(squareList) do
        if sq:getZombie() then
            zombieNum = zombieNum + 1
            if SandboxVars.StairsAlert.DisplayMarker == true then
                local indicator = getWorldMarkers():addDirectionArrow(playerObj, sq:getX(), sq:getY(), sq:getZ(), "Zombie", 1.0, 0.2, 0.2, 1.0)
                table.insert(indicatorList, indicator)
            end
        end
    end

    if SandboxVars.StairsAlert.DisplayMarker == true then
        delayFunction(function()
            for _, indicator in pairs(indicatorList) do
                indicator:remove()
                indicator = nil
            end
        end, 100)
    end

    if zombieNum > 0 then
        if SandboxVars.StairsAlert.DisplayZombieAmount == false then
            playerObj:Say(getText("IGUI_Stairs_Alert"))
        else
            playerObj:Say(getText("IGUI_Stairs_Alert") .. " " .. string.gsub(getText("IGUI_Stairs_Alert_Extra"), "#", zombieNum))
        end
    end
end

local onKeyPressed = function(keyIndex)
	local playerObj = getPlayer(); if not playerObj then return end
    if keyIndex == getCore():getKey("Interact") then

        local playerSquare = playerObj:getSquare(); if not playerSquare then return end

        if playerSquare:HasStairsNorth() == true then
            fetchSquaresAroundStairs(playerObj, playerSquare, "North")
        elseif playerSquare:HasStairsWest() == true then
            fetchSquaresAroundStairs(playerObj, playerSquare, "West")
        end
    end
end

Events.OnKeyPressed.Add(onKeyPressed)