require "Vehicles/VehicleDistributions"
require "CommonTemplates/CommonDistributions"

VehicleDistributions.AutotsarTrailer = {
	
	TrailerTrunk = {
		rolls = 3,
		items = {
			"Hammer", 17,
			"NailsBox", 15,
			"NailsBox", 15,
			"Plank", 5,
			"Plank", 5,
			"Plank", 5,
			"Plank", 5,
			"Screwdriver", 5,
			"Saw", 10,
			"DuctTape", 2,
			"Glue", 2,
			"Twine", 2,
			"Woodglue", 10,
			"BookCarpentry1", 4,
			"BookCarpentry2", 3,
			"BookCarpentry3", 2,
			"BookCarpentry4", 1,
			"BookCarpentry5", 0.6,
			"Screwdriver", 1,
		}
	},
	
	Fridge = {
		rolls = 1,
		items = {
			"Milk", 103,
			"Milk", 103,
			"BeefJerky", 103,
			"Bread", 12,
			"Carrots", 12,
			"Steak", 13,
			"MeatPatty", 13,
			"Chicken", 13,
			"Ham", 3,
			"Salmon", 3,
			"Cheese", 2,
			"Watermelon", 2,
			"Broccoli", 2,
			"Pie", 3,
			"PopBottle", 3,
			"PopBottle", 3,
			"Butter", 3,
			"EggCarton", 2,
			"EggCarton", 2,
			"Apple", 2,
			"Orange", 2,
			"Banana", 2,
			"farming.RedRadish", 2,
			"farming.Strewberrie", 2,
			"Cherry", 2,
			"farming.Tomato", 2,
			"farming.Cabbage", 2,
			"Lettuce", 3,
			"Pickles", 3,
			"BellPepper", 3,
			"Peach", 3,
			"CakeSlice", 3,
			"Mustard", 2,
			"Ketchup", 2,
			"Processedcheese", 2,
			"Corndog", 2,
			"PorkChop", 3,
			"MuttonChop", 3,
			"Onion", 3,
			"Lemon", 3,
			"WaterBottleFull", 3,
			"WaterBottleFull", 3,
			"WaterBottleFull", 3,
			"Wine", 2,
			"Corn", 4,
			"Eggplant", 4,
			"Leek", 4,
			"Grapes", 4,
			"farming.Bacon", 4,
			"farming.MayonnaiseFull", 2,
			"farming.RemouladeFull", 0.5,
			"Worm", 0.3,
			"Avocado", 3,
			"Pineapple", 3,
			"Zucchini", 3,
			"Tofu", 2,
			"Yoghurt", 3,
			"JuiceBox", 1,
			"BeerCan", 1,
			"BeerCan", 1,
			"BeerCan", 1,
			"BeerBottle", 1,
		}
	},
	
	Oven = {
		rolls = 1,
		items = {
			"Hammer", 17,
			"NailsBox", 15,
			"NailsBox", 15,
			"Plank", 5,
			"Plank", 5,
			"Plank", 5,
			"Plank", 5,
			"Screwdriver", 5,
			"Saw", 10,
			"DuctTape", 2,
			"Glue", 2,
			"Twine", 2,
			"Woodglue", 10,
			"BookCarpentry1", 4,
			"BookCarpentry2", 3,
			"BookCarpentry3", 2,
			"BookCarpentry4", 1,
			"BookCarpentry5", 0.6,
			"Screwdriver", 1,
		}
	},
	
	GunRack = {
		rolls = 1,
		items = {
			"Pills", 1,
			"PillsBeta", 1,
			"PillsAntiDep", 1,
			"PillsSleepingTablets", 1,
			"PillsVitamins", 1,
			"Antibiotics", 1,
			"Bandage", 1,
			"Bandage", 1,
			"Bandaid", 1,
			"Bandaid", 1,
			"FirstAidKit", 1,
			"Tweezers", 1,
			"Disinfectant", 1,
			"AlcoholWipes", 1,
			"SutureNeedle", 1,
			"Scalpel", 0.005,
			"Pistol", 1,
			"Revolver_Short", 1,
			"DoubleBarrelShotgun", 1,
			"ShotgunShells", 1,
			"Bullets9mm", 1,
			"Bullets38", 1,
			"BaseballBat", 1,
			"Cigarettes", 1,
			"Cigarettes", 1,
			"Axe", 0.8,
			"Newspaper", 0.2,
			"Magazine", 0.2,
			"FishingMag1", 0.2,
			"FishingMag2", 0.2,
			"HuntingMag1", 0.2,
			"HuntingMag2", 0.2,
			"HuntingMag3", 0.2,
			"HerbalistMag", 0.2,
			"CookingMag1", 0.2,
			"CookingMag2", 0.2,
			"ElectronicsMag1", 0.2,
			"ElectronicsMag2", 0.2,
			"ElectronicsMag3", 0.2,
			"ElectronicsMag4", 0.2,
			"ElectronicsMag5", 0.2,
			"MechanicMag1", 0.2,
			"MechanicMag2", 0.2,
			"MechanicMag3", 0.2,
			"EngineerMagazine1", 0.2,
			"EngineerMagazine2", 0.2,
			"MetalworkMag1", 0.2,
			"MetalworkMag2", 0.2,
			"MetalworkMag3", 0.2,
			"MetalworkMag4", 0.2,
		}
	},
	
	TruckBed =
	{
		rolls = 1,
		items = {
			"LugWrench", 5,
			"TirePump", 5,
			"NormalTire2", 5,
			"Jack", 5,
			"Wrench", 5,
			"Screwdriver", 5,
			"CarBattery2", 5,
			"FirstAidKit", 5,
			"DuctTape", 3,
			"Twine", 3,
			"Tarp", 3,
			"EmptySandbag", 3,
			"LeadPipe", 1,
			"MetalPipe", 1,
			"PipeWrench", 1,
			"BaseballBat", 1,
			"CorpseMale", 0.01,
			"CorpseFemale", 0.01,
			"Crisps",5,
			"Crisps2", 5,
			"Crisps3", 5,
			"Crisps4", 5,
			"Cereal", 5,
			"Dogfood", 5,
			"TVDinner",5,
			"TinnedSoup", 5,
			"TinnedBeans", 5,
			"CannedCornedBeef", 2,
			"Macandcheese", 2,
			"CannedChili", 2,
			"CannedBolognese", 2,
			"CannedCarrots2", 2,
			"CannedCorn", 2,
			"CannedMushroomSoup", 2,
			"CannedPeas", 2,
			"CannedPotato2", 2,
			"CannedSardines", 2,
			"CannedTomato2", 2,
			"ShotgunShellsBox", 3,
			"ShotgunShellsBox", 3,
			"Shotgun", 0.8,
			"DoubleBarrelShotgun", 1,
			"Pillow", 0.8,
			"SmokeBomb", 0.5,
			"FlameTrap", 0.5,
			"Aerosolbomb", 0.5,
			"camping.CampfireKit", 0.9,
			"farming.CarrotBagSeed", 0.5,
			"farming.BroccoliBagSeed", 0.5,
			"farming.RedRadishBagSeed", 0.5,
			"farming.StrewberrieBagSeed", 0.5,
			"farming.TomatoBagSeed", 0.5,
			"farming.PotatoBagSeed", 0.5,
			"farming.CabbageBagSeed", 0.5,
			"farming.HandShovel", 0.5,
			"farming.Shovel", 5,
			"farming.WateredCan", 2,
			"BookFarming1", 0.5,
			"BookForaging1", 0.5,
			"BookForaging2", 0.5,
			"BookForaging3", 0.7,
			"BookForaging4", 0.5,
			"BookForaging5", 0.3,
			"FarmingMag1", 0.5,
			"BookFarming2", 0.5,
			"BookFarming3", 0.5,
			"BookFarming4", 0.5,
			"BookFarming5", 0.6,
			"CompostBag", 1,
			"Fertilizer", 1,
			}
	}
}

VehicleDistributions.AutotsarKbac = {
	
	TruckBed =
	{
		rolls = 1,
		items = {
			"Base.EmptyPetrolCan", 101,
			"LugWrench", 5,
			"TirePump", 5,
			"NormalTire2", 5,
			"Jack", 5,
			"Wrench", 5,
			"Screwdriver", 5,
			"CarBattery2", 5,
			"FirstAidKit", 5,
			"DuctTape", 3,
			"Twine", 3,
			"Tarp", 3,
			"EmptySandbag", 3,
			"LeadPipe", 1,
			"MetalPipe", 1,
			"PipeWrench", 1,
			"BaseballBat", 1,
			"CorpseMale", 0.01,
			"CorpseFemale", 0.01,
			"Crisps",5,
			"Crisps2", 5,
			"Crisps3", 5,
			"Crisps4", 5,
			"Cereal", 5,
			"Dogfood", 5,
			"TVDinner",5,
			"TinnedSoup", 5,
			"TinnedBeans", 5,
			"CannedCornedBeef", 2,
			"Macandcheese", 2,
			"CannedChili", 2,
			}
	}
}

local distributionTable = VehicleDistributions[1]

distributionTable["TrailerHome"] = {
	Normal = VehicleDistributions.CommonTemplatesDist,
}

distributionTable["TrailerHomeExplorer"] = {
	Normal = VehicleDistributions.CommonTemplatesDist,
}

distributionTable["TrailerHomeHartman"] = {
	Normal = VehicleDistributions.CommonTemplatesDist,
}

distributionTable["TrailerFirst"] = {
	Normal = VehicleDistributions.AutotsarTrailer,
	Specific = { VehicleDistributions.Groceries, VehicleDistributions.Fisherman, VehicleDistributions.Carpenter, VehicleDistributions.Farmer, VehicleDistributions.Electrician, VehicleDistributions.MetalWelder, VehicleDistributions.ConstructionWorker, VehicleDistributions.Painter, VehicleDistributions.TowBar},
}

distributionTable["TrailerSecond"] = {
	Normal = VehicleDistributions.AutotsarTrailer,
	Specific = { VehicleDistributions.Groceries, VehicleDistributions.Fisherman, VehicleDistributions.Carpenter, VehicleDistributions.Farmer, VehicleDistributions.Electrician, VehicleDistributions.MetalWelder, VehicleDistributions.ConstructionWorker, VehicleDistributions.Painter, VehicleDistributions.TowBar},
}

distributionTable["TrailerKbac"] = {
	Normal = VehicleDistributions.AutotsarKbac,
}

distributionTable["Trailer"] = {
	Normal = VehicleDistributions.AutotsarTrailer,
	Specific = { VehicleDistributions.Groceries, VehicleDistributions.Fisherman, VehicleDistributions.Carpenter, VehicleDistributions.Farmer, VehicleDistributions.Electrician, VehicleDistributions.MetalWelder, VehicleDistributions.ConstructionWorker, VehicleDistributions.Painter, VehicleDistributions.TowBar},
}

distributionTable["TrailerCover"] = {
	Normal = VehicleDistributions.AutotsarTrailer,
	Specific = { VehicleDistributions.Groceries, VehicleDistributions.Fisherman, VehicleDistributions.Carpenter, VehicleDistributions.Farmer, VehicleDistributions.Electrician, VehicleDistributions.MetalWelder, VehicleDistributions.ConstructionWorker, VehicleDistributions.Painter, VehicleDistributions.TowBar},
}
	

table.insert(VehicleDistributions, 1, distributionTable);
