/*
 * Decompiled with CFR 0.152.
 */
package haage.config;

public class LocatorHeadsConfig {
    public boolean enableMod = true;
    public boolean renderHeads = true;
    public boolean alwaysShowXP = false;
    public boolean showCompass = false;
    public int compassColor = 0xFFFFFF;
    public boolean compassShadow = true;
    public boolean enableTeamBorder = false;
    public BorderThickness teamBorderThickness = BorderThickness.NORMAL;
    public BorderStyle borderStyle = BorderStyle.TEAM_COLOR;
    public int staticBorderColor = 0xFFFFFF;
    public int headSizeMultiplier = 5;
    public NameDisplayMode showPlayerNames = NameDisplayMode.OFF;
    public PlayerFilterMode playerFilterMode = PlayerFilterMode.ALL;
    public String includedPlayers = "";
    public String excludedPlayers = "";

    public double getHeadSizeMultiplier() {
        if (this.headSizeMultiplier == 0) {
            return 1.0;
        }
        switch (this.headSizeMultiplier) {
            case 1: {
                return 0.5;
            }
            case 2: {
                return 0.6;
            }
            case 3: {
                return 0.7;
            }
            case 4: {
                return 0.8;
            }
            case 5: {
                return 1.0;
            }
            case 6: {
                return 1.1;
            }
            case 7: {
                return 1.2;
            }
            case 8: {
                return 1.3;
            }
            case 9: {
                return 1.5;
            }
        }
        return 1.0;
    }

    public String getHeadSizeDisplayText() {
        return String.format("%.1fx", this.getHeadSizeMultiplier());
    }

    public static enum BorderThickness {
        THIN(0.3),
        MEDIUM(0.5),
        NORMAL(1.0),
        THICK(2.0);

        private final double value;

        private BorderThickness(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }
    }

    public static enum BorderStyle {
        TEAM_COLOR,
        STATIC_COLOR;

    }

    public static enum NameDisplayMode {
        OFF,
        ALWAYS,
        LOOKING_AT,
        PLAYER_LIST;

    }

    public static enum PlayerFilterMode {
        ALL,
        INCLUDE,
        EXCLUDE;

    }
}

