/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import java.util.ArrayList;
import java.util.List;
import journeymap.api.client.impl.OptionsDisplayFactory;
import journeymap.client.Constants;
import journeymap.client.InternalStateHandler;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.dialog.import_export.ImportExportPopup;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public abstract class OptionScreen
extends JmUILegacy {
    protected final int panelTop = 70;
    protected final int panelBottomMargin = 30;
    protected Button buttonClose;
    protected Button buttonAbout;
    protected Button importExport;
    protected Button buttonServer;
    protected Button buttonMultiplayer;
    protected Button buttonAddons;
    protected List<Button> specialBottomButtons = new ArrayList<Button>();
    protected Button clientOptions;
    protected class_437 returnDisplay;
    protected boolean clientOnly = false;

    public OptionScreen(String title, class_437 returnDisplay, boolean clientOnly) {
        super(title, returnDisplay);
        if (returnDisplay == null) {
            returnDisplayStack.pop();
        }
        this.clientOnly = clientOnly;
    }

    public OptionScreen(String title) {
        super(title);
        returnDisplayStack.pop();
    }

    @Override
    public void method_25426() {
        ButtonList bottomRow;
        class_1132 server;
        boolean isSinglePlayer;
        this.setRenderBottomBar(true);
        this.getRenderables().clear();
        this.buttonClose = this.method_37063(new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonClose.setDefaultStyle(false);
        this.importExport = this.method_37063(new Button(Constants.getString("jm.common.importexport_button"), this::importExportClicked));
        this.importExport.setDefaultStyle(false);
        this.buttonAbout = this.method_37063(new Button(Constants.getString("jm.common.splash_about"), button -> UIManager.INSTANCE.openSplash(this)));
        this.buttonAbout.setDefaultStyle(false);
        this.buttonServer = new Button(Constants.getString("jm.server.edit.label.admin.edit"), button -> UIManager.INSTANCE.openServerEditor(null));
        this.setUpTopButton(this.buttonServer);
        this.buttonMultiplayer = new Button(Constants.getString("jm.options.multiplayer.button_label"), button -> UIManager.INSTANCE.openMultiplayerEditor(null));
        this.setUpTopButton(this.buttonMultiplayer);
        this.buttonAddons = new Button(Constants.getString("jm.common.addon_options"), button -> UIManager.INSTANCE.openAddonOptionsEditor(null, this.clientOnly));
        this.setUpTopButton(this.buttonAddons);
        if (OptionsDisplayFactory.PROPERTIES_REGISTRY.isEmpty()) {
            this.buttonAddons.setTooltip(Constants.getString("jm.common.addon_options_invalid"));
            this.disableButton(this.buttonAddons);
        }
        this.clientOptions = new Button(Constants.getString("jm.common.client_options"), button -> UIManager.INSTANCE.openOptionsManager(null, this.clientOnly));
        this.setUpTopButton(this.clientOptions);
        InternalStateHandler stateHandler = JourneymapClient.getInstance().getStateHandler();
        if (!stateHandler.canServerAdmin() && !stateHandler.isReadOnlyServerAdmin() || this.clientOnly) {
            boolean isAdmin = stateHandler.isServerAdmin();
            boolean hasServer = stateHandler.isJourneyMapServerConnection();
            if (!isAdmin && hasServer && !stateHandler.isReadOnlyServerAdmin()) {
                this.buttonServer.setTooltip(Constants.getString("jm.server.button.no_permission.tooltip"));
            } else if (!hasServer) {
                this.buttonServer.setTooltip(Constants.getString("jm.server.button.no_server.tooltip"));
            }
            this.disableButton(this.buttonServer);
        }
        boolean bl = isSinglePlayer = (server = this.field_22787.method_1576()) != null && !server.method_3860();
        if (!stateHandler.isMultiplayerOptionsAllowed() || isSinglePlayer || !stateHandler.isJourneyMapServerConnection()) {
            boolean hasServer = stateHandler.isJourneyMapServerConnection();
            if (isSinglePlayer) {
                this.buttonMultiplayer.setTooltip(Constants.getString("menu.singleplayer"));
            } else if (hasServer) {
                this.buttonMultiplayer.setTooltip(Constants.getString("jm.server.button.no_permission.tooltip"));
            } else {
                this.buttonMultiplayer.setTooltip(Constants.getString("jm.server.button.no_server.tooltip"));
            }
            this.disableButton(this.buttonMultiplayer);
        }
        if (this.specialBottomButtons.isEmpty()) {
            bottomRow = new ButtonList(this.buttonAbout, this.importExport, this.buttonClose);
        } else {
            bottomRow = new ButtonList();
            bottomRow.add(this.buttonAbout);
            bottomRow.add(this.importExport);
            bottomRow.addAll(this.specialBottomButtons);
            bottomRow.add(this.buttonClose);
        }
        bottomRow.equalizeWidths(this.getFontRenderer());
        bottomRow.setWidths(Math.max(100, this.buttonAbout.method_25368()));
        bottomRow.layoutCenteredHorizontal(this.field_22789 / 2, this.field_22790 - 25, true, 4);
        ButtonList topRow = new ButtonList(this.clientOptions, this.buttonAddons, this.buttonServer, this.buttonMultiplayer);
        topRow.equalizeWidths(this.getFontRenderer());
        topRow.setWidths(Math.max(100, this.clientOptions.method_25368()));
        topRow.layoutCenteredHorizontal(this.field_22789 / 2, 46, true, 1);
        this.getRenderables().addAll(bottomRow);
        this.getRenderables().addAll(topRow);
        if (this.clientOnly) {
            this.disableButton(this.buttonAbout);
        }
    }

    private void importExportClicked(class_4185 button) {
        new ImportExportPopup().display();
    }

    private void setUpTopButton(Button button) {
        this.method_37063(button);
        button.setEnabled(true);
        button.setDefaultStyle(false);
        button.setDrawBackground(false);
        button.setDrawBackgroundOnDisable(false);
    }

    private void disableButton(Button button) {
        button.setEnabled(false);
        button.setDefaultStyle(false);
        button.setDrawBackground(true);
        button.setDrawBackgroundOnDisable(true);
        class_5250 component = class_2561.method_43470((String)(String.valueOf(class_124.field_1055) + button.getLabel()));
        button.method_25355((class_2561)component);
    }

    @Override
    protected void renderBottomBar(class_332 graphics, class_4587 poseStack) {
        DrawUtil.drawRectangle(graphics, 0.0, this.field_22790 - 30, this.field_22789, this.field_22790, 0, 0.8f);
    }
}

