/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.import_export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import journeymap.client.ui.dialog.import_export.ImportPopup;

public class ImportFolderPopup
extends ImportPopup {
    protected ImportFolderPopup(File folder) {
        super(folder);
    }

    @Override
    protected Set<String> scanForFolders() {
        TreeSet<String> topLevelFolders = new TreeSet<String>();
        File[] files = this.sourceFile.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || file.listFiles().length <= 0) continue;
                topLevelFolders.add(file.getName());
            }
        }
        return topLevelFolders;
    }

    @Override
    protected void importFolders(Set<String> selectedFolders) throws IOException {
        this.copySelectedFolders(this.sourceFile, this.jmWorldDir, selectedFolders);
    }

    private void copySelectedFolders(File sourceDir, File destDir, Set<String> selectedFolders) throws IOException {
        for (String folderName : selectedFolders) {
            File sourceFolder = new File(sourceDir, folderName);
            if (!sourceFolder.exists() || !sourceFolder.isDirectory()) continue;
            File destFolder = new File(destDir, folderName);
            this.copyFolder(sourceFolder, destFolder);
        }
    }

    private void copyFolder(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            File[] files;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            if ((files = source.listFiles()) != null) {
                for (File file : files) {
                    File destFile = new File(destination, file.getName());
                    if (file.isDirectory()) {
                        this.copyFolder(file, destFile);
                        continue;
                    }
                    this.copyFile(file, destFile);
                }
            }
        } else {
            this.copyFile(source, destination);
        }
    }

    private void copyFile(File source, File destination) throws IOException {
        try (FileInputStream fis = new FileInputStream(source);
             FileOutputStream fos = new FileOutputStream(destination);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                fos.write(buffer, 0, length);
            }
        }
    }
}

