/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import javax.annotation.Nullable;
import journeymap.client.texture.gl.GlMaskedTexture;
import journeymap.common.Journeymap;
import net.minecraft.class_1011;
import net.minecraft.class_1044;

public class MaskedTexture
extends class_1044 {
    private class_1011 pixels;
    private String description;
    private GpuTexture depthTexture;
    private GpuTextureView depthView;

    public MaskedTexture(String description, class_1011 pixels) {
        this.pixels = pixels;
        this.description = description;
        this.depthTexture = GlMaskedTexture.createTexture(description, 8, TextureFormat.DEPTH32, pixels.method_4307(), pixels.method_4323(), 1, 1);
        this.field_56974 = GlMaskedTexture.createTexture(description, 12, TextureFormat.RGBA8, pixels.method_4307(), pixels.method_4323(), 1, 1);
        this.depthView = RenderSystem.getDevice().createTextureView(this.depthTexture);
        this.field_60597 = RenderSystem.getDevice().createTextureView(this.field_56974);
    }

    public void upload() {
        if (this.pixels != null && this.field_56974 != null) {
            RenderSystem.getDevice().createCommandEncoder().writeToTexture(this.depthTexture, this.pixels);
        } else {
            Journeymap.getLogger().warn("Trying to upload disposed texture {}", (Object)this.method_68004().getLabel());
        }
    }

    public GpuTexture getDepthTexture() {
        return this.depthTexture;
    }

    public GpuTextureView getDepthView() {
        return this.depthView;
    }

    @Nullable
    public class_1011 getPixels() {
        return this.pixels;
    }

    public void setPixels(class_1011 pixels) {
        if (this.pixels != null) {
            this.pixels.close();
        }
        this.pixels = pixels;
    }

    public void close() {
        if (this.pixels != null) {
            this.pixels.close();
            this.pixels = null;
        }
        super.close();
    }
}

