/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.map;

import com.google.common.base.MoreObjects;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import journeymap.api.v2.client.display.Context;
import journeymap.client.model.map.MapState;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.ImageHolder;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.model.region.RegionImageCache;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.RegionTexture;
import journeymap.client.texture.TextureCache;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class RegionTile
implements RegionTexture.Listener<RegionTexture> {
    public static final int TILE_SIZE = 512;
    private static int queueCount = 0;
    private static final int MAX_TILE_QUEUE = 10;
    private final MapState state;
    private RegionTexture texture;
    private final RegionCoord regionCoord;
    private boolean textureQueued = false;
    private boolean shouldRender = false;
    private volatile Future<RegionTexture> regionFuture;
    private double x;
    private double y;
    private int zoom = 512;
    private boolean textureReady = false;

    RegionTile(RegionCoord regionCoord, MapState state) {
        this.state = state;
        this.regionCoord = regionCoord;
    }

    public static String toCacheKey(RegionCoord regionCoord, MapType mapType) {
        return regionCoord.cacheKey() + mapType.toCacheKey();
    }

    public void render(class_332 graphics, class_4597.class_4598 buffers, class_4587 poseStack, Context.UI context, double pixelOffsetX, double pixelOffsetZ, float alpha) {
        if (this.shouldRender && this.texture != null && this.textureReady) {
            ImageHolder holder;
            if (!this.updateRegionTexture() && (holder = this.getRegionTextureHolder(true)) != null) {
                this.texture = holder.getTexture();
            }
            if (this.texture != null && this.texture.isBound() && !this.texture.isDefunct() && this.texture.hasImage()) {
                double x = this.x + pixelOffsetX;
                double y = this.y + pixelOffsetZ;
                int scaledZoom = this.zoom;
                if (this.texture.method_71659() != null) {
                    class_1921 renderType = JMRenderTypes.getRegionTile(this.texture, this.state.getMapType().getShader());
                    class_4588 vertexBuilder = buffers.method_73477(renderType);
                    DrawUtil.drawQuad(poseStack, vertexBuilder, 0xFFFFFF, alpha, x, y, (double)scaledZoom, (double)scaledZoom, 0.0, false);
                }
            }
        } else if (this.shouldRender && !this.textureQueued && queueCount < 10) {
            this.textureQueued = true;
            ++queueCount;
            CompletableFuture.supplyAsync(() -> this.getRegionTextureHolder(false).getTexture(), (Executor)class_156.method_18349()).whenComplete((tex, throwable) -> {
                this.texture = tex;
                this.textureReady = true;
                --queueCount;
            });
        }
    }

    public void setPosition(RegionCoord centerRegion, Point2D.Double centerPixel, Rectangle2D.Double regionBounds, double offsetX, double offsetZ, int zoom) {
        this.zoom = zoom;
        if (regionBounds.contains(this.regionCoord.regionX, this.regionCoord.regionZ)) {
            this.shouldRender = true;
            if (centerRegion.regionX == this.regionCoord.regionX && centerRegion.regionZ == this.regionCoord.regionZ) {
                this.x = centerPixel.getX();
                this.y = centerPixel.getY();
            } else {
                int diffX = this.regionCoord.regionX - centerRegion.regionX;
                int diffZ = this.regionCoord.regionZ - centerRegion.regionZ;
                this.x = centerPixel.getX() + (double)(zoom * diffX);
                this.y = centerPixel.getY() + (double)(zoom * diffZ);
            }
            this.x += offsetX;
            this.y += offsetZ;
        } else {
            this.shouldRender = false;
            this.textureQueued = false;
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getZoom() {
        return this.zoom;
    }

    public RegionTexture getTexture() {
        return this.texture;
    }

    public RegionCoord getRegionCoord() {
        return this.regionCoord;
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    private boolean updateRegionTexture() {
        ImageHolder imageHolder;
        if (this.regionFuture != null) {
            if (!this.regionFuture.isDone()) {
                return true;
            }
            this.regionFuture = null;
        }
        if ((imageHolder = this.getRegionTextureHolder(true)) != null && imageHolder.hasTexture()) {
            RegionTexture tex = imageHolder.getTexture();
            tex.addListener(this);
            if (tex.bindNeeded()) {
                tex.bind();
            }
            return false;
        }
        this.regionFuture = TextureCache.scheduleTextureTask(() -> {
            RegionTexture tex = this.getRegionTextureHolder(false).getTexture();
            tex.addListener(this);
            return tex;
        });
        return true;
    }

    ImageHolder getRegionTextureHolder(boolean async) {
        if (async) {
            return RegionImageCache.INSTANCE.getRegionImageSet(this.regionCoord).getHolderAsyncLoad(this.state.getMapType());
        }
        return RegionImageCache.INSTANCE.getRegionImageSet(this.regionCoord).getHolder(this.state.getMapType());
    }

    public int hashCode() {
        return RegionTile.toCacheKey(this.regionCoord, this.state.getMapType()).hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rc", (Object)this.regionCoord).add("type", (Object)this.state.getMapType()).add("zoom", this.zoom).add("x", this.x).add("y", this.y).toString();
    }

    @Override
    public void textureImageUpdated(RegionTexture texture) {
        if (!texture.isDefunct()) {
            this.texture = texture;
        }
    }

    public void close() {
        if (this.regionFuture != null && !this.regionFuture.isDone()) {
            this.regionFuture.cancel(true);
        }
        this.regionFuture = null;
        if (this.texture != null) {
            this.texture.removeListener(this);
            this.texture = null;
        }
        this.textureReady = false;
        this.textureQueued = false;
        this.shouldRender = false;
    }
}

