/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.structure;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.OptionBinding;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.client.config.structure.StatefulOption;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.CyclingControl;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class EnumOption<E extends Enum<E>>
extends StatefulOption<E> {
    public final Class<E> enumClass;
    private final DependentValue<Set<E>> allowedValues;
    private final Function<E, class_2561> elementNameProvider;

    public EnumOption(class_2960 id, Collection<class_2960> dependencies, class_2561 name, DependentValue<Boolean> enabled, StorageEventHandler storage, Function<E, class_2561> tooltipProvider, OptionImpact impact, EnumSet<OptionFlag> flags, DependentValue<E> defaultValue, OptionBinding<E> binding, Class<E> enumClass, DependentValue<Set<E>> allowedValues, Function<E, class_2561> elementNameProvider) {
        super(id, dependencies, name, enabled, storage, tooltipProvider, impact, flags, defaultValue, binding);
        this.enumClass = enumClass;
        this.allowedValues = allowedValues;
        this.elementNameProvider = elementNameProvider;
    }

    @Override
    void visitDependentValues(Consumer<DependentValue<?>> visitor) {
        super.visitDependentValues(visitor);
        visitor.accept(this.allowedValues);
    }

    @Override
    public boolean isValueValid(E value) {
        return this.allowedValues.get(this.state).contains(value);
    }

    @Override
    Control createControl() {
        return new CyclingControl<E>(this, this.enumClass);
    }

    public boolean isValueAllowed(E value) {
        return this.allowedValues.get(this.state).contains(value);
    }

    public class_2561 getElementName(E element) {
        return this.elementNameProvider.apply(element);
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    public DependentValue<Set<E>> getAllowedValues() {
        return this.allowedValues;
    }

    public Function<E, class_2561> getElementNameProvider() {
        return this.elementNameProvider;
    }
}

