/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.structure;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.client.config.builder.OptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.search.BigramSearchIndex;
import net.caffeinemc.mods.sodium.client.config.search.SearchIndex;
import net.caffeinemc.mods.sodium.client.config.search.SearchQuerySession;
import net.caffeinemc.mods.sodium.client.config.structure.BooleanOption;
import net.caffeinemc.mods.sodium.client.config.structure.EnumOption;
import net.caffeinemc.mods.sodium.client.config.structure.IntegerOption;
import net.caffeinemc.mods.sodium.client.config.structure.ModOptions;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.structure.OptionGroup;
import net.caffeinemc.mods.sodium.client.config.structure.OptionOverlay;
import net.caffeinemc.mods.sodium.client.config.structure.OptionOverride;
import net.caffeinemc.mods.sodium.client.config.structure.Page;
import net.caffeinemc.mods.sodium.client.config.structure.StatefulOption;
import net.caffeinemc.mods.sodium.client.config.value.DynamicValue;
import net.caffeinemc.mods.sodium.client.console.Console;
import net.caffeinemc.mods.sodium.client.console.message.MessageLevel;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class Config
implements ConfigState {
    private final Map<class_2960, Option> options = new Object2ReferenceLinkedOpenHashMap();
    private final ObjectOpenHashSet<StorageEventHandler> pendingStorageHandlers = new ObjectOpenHashSet();
    private final ImmutableList<ModOptions> modOptions;
    private final SearchIndex searchIndex = new BigramSearchIndex(this::registerSearchIndex);
    private final Collection<DynamicValue<?>> globalRebuildDependents = new ObjectArrayList();

    public Config(ImmutableList<ModOptions> modOptions) {
        this.modOptions = modOptions;
        this.collectOptions();
        this.applyOptionChanges();
        this.validateDependencies();
        for (Option option : this.options.values()) {
            option.loadValueInitial();
        }
        this.resetAllOptionsFromBindings();
    }

    private void registerSearchIndex() {
        for (ModOptions modConfig : this.modOptions) {
            modConfig.registerTextSources(this.searchIndex);
        }
    }

    public SearchQuerySession startSearchQuery() {
        return this.searchIndex.startQuery();
    }

    private void collectOptions() {
        for (ModOptions modConfig : this.modOptions) {
            for (Page page : modConfig.pages()) {
                for (OptionGroup group : page.groups()) {
                    for (Option option : group.options()) {
                        if (!option.id.method_12836().equals(modConfig.configId())) {
                            throw new IllegalArgumentException("Namespace of option id '" + String.valueOf(option.id) + "' does not match the configId '" + modConfig.configId() + "' of the enclosing mod config");
                        }
                        this.options.put(option.id, option);
                        option.setParentConfig(this);
                    }
                }
            }
        }
    }

    private void applyOptionChanges() {
        Option option;
        int i;
        List<Option> options;
        Object2ReferenceOpenHashMap overrides = new Object2ReferenceOpenHashMap();
        Object2ReferenceOpenHashMap overlays = new Object2ReferenceOpenHashMap();
        for (ModOptions modConfig : this.modOptions) {
            for (OptionOverride override : modConfig.overrides()) {
                if (override.target().method_12836().equals(modConfig.configId())) {
                    throw new IllegalArgumentException("Override by mod '" + modConfig.configId() + "' targets its own option '" + String.valueOf(override.target()) + "'");
                }
                if (overrides.put((Object)override.target(), (Object)override) == null) continue;
                throw new IllegalArgumentException("Multiple overrides for option '" + String.valueOf(override.target()) + "'");
            }
            for (OptionOverlay overlay : modConfig.overlays()) {
                if (overlay.target().method_12836().equals(modConfig.configId())) {
                    throw new IllegalArgumentException("Overlay by mod '" + modConfig.configId() + "' targets its own option '" + String.valueOf(overlay.target()) + "'");
                }
                if (overlays.put((Object)overlay.target(), (Object)overlay) == null) continue;
                throw new IllegalArgumentException("Multiple overlays for option '" + String.valueOf(overlay.target()) + "'");
            }
        }
        for (ModOptions modConfig : this.modOptions) {
            for (Page page : modConfig.pages()) {
                for (OptionGroup group : page.groups()) {
                    options = group.options();
                    for (i = 0; i < options.size(); ++i) {
                        option = options.get(i);
                        OptionOverride override = (OptionOverride)overrides.get((Object)option.id);
                        if (override == null) continue;
                        Option replacement = override.change();
                        this.exchangeOption(options, i, replacement, option);
                    }
                }
            }
        }
        for (ModOptions modConfig : this.modOptions) {
            for (Page page : modConfig.pages()) {
                for (OptionGroup group : page.groups()) {
                    options = group.options();
                    for (i = 0; i < options.size(); ++i) {
                        option = options.get(i);
                        OptionOverlay overlay = (OptionOverlay)overlays.get((Object)option.id);
                        if (overlay == null) continue;
                        OptionBuilderImpl<?> change = overlay.change();
                        Object overlaidOption = change.buildWithBaseOption(option);
                        this.exchangeOption(options, i, (Option)overlaidOption, option);
                    }
                }
            }
        }
    }

    private void exchangeOption(List<Option> optionGroupList, int i, Option replacement, Option original) {
        optionGroupList.set(i, replacement);
        this.options.remove(original.id);
        this.options.put(replacement.id, replacement);
        replacement.setParentConfig(this);
        original.setParentConfig(null);
    }

    private void validateDependencies() {
        for (Option option : this.options.values()) {
            for (class_2960 dependency : option.dependencies) {
                if (this.options.containsKey(dependency) || dependency.equals((Object)ConfigState.UPDATE_ON_REBUILD)) continue;
                throw new IllegalArgumentException("Option " + String.valueOf(option.id) + " depends on non-existent option " + String.valueOf(dependency));
            }
            option.visitDependentValues(dependent -> {
                if (dependent instanceof DynamicValue) {
                    DynamicValue dynamicValue = (DynamicValue)dependent;
                    for (class_2960 dependency : dependent.getDependencies()) {
                        if (dependency.equals((Object)ConfigState.UPDATE_ON_REBUILD)) {
                            this.globalRebuildDependents.add(dynamicValue);
                            continue;
                        }
                        Option dependencyOption = this.options.get(dependency);
                        if (!(dependencyOption instanceof StatefulOption)) continue;
                        StatefulOption statefulOption = (StatefulOption)dependencyOption;
                        statefulOption.registerDependent(dynamicValue);
                    }
                }
            });
        }
        ObjectOpenHashSet stack = new ObjectOpenHashSet();
        ObjectOpenHashSet finished = new ObjectOpenHashSet();
        for (Option option : this.options.values()) {
            this.checkDependencyCycles(option, (ObjectOpenHashSet<class_2960>)stack, (ObjectOpenHashSet<class_2960>)finished);
        }
    }

    void invalidateDependents(Collection<DynamicValue<?>> dependents) {
        for (DynamicValue<?> dependent : dependents) {
            dependent.invalidateCache();
        }
    }

    private void checkDependencyCycles(Option option, ObjectOpenHashSet<class_2960> stack, ObjectOpenHashSet<class_2960> finished) {
        if (!stack.add((Object)option.id)) {
            throw new IllegalArgumentException("Cycle detected in dependency graph starting from option " + String.valueOf(option.id));
        }
        for (class_2960 dependency : option.dependencies) {
            Option dependencyOption;
            if (finished.contains((Object)dependency) || (dependencyOption = this.options.get(dependency)) == null) continue;
            this.checkDependencyCycles(dependencyOption, stack, finished);
        }
        stack.remove((Object)option.id);
        finished.add((Object)option.id);
    }

    public void resetAllOptionsFromBindings() {
        for (Option option : this.options.values()) {
            option.resetFromBinding();
        }
    }

    public void applyAllOptions() {
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        for (Option option : this.options.values()) {
            EnumSet<OptionFlag> optionFlags;
            if (!option.applyChanges() || (optionFlags = option.getFlags()) == null) continue;
            flags.addAll(optionFlags);
        }
        this.flushStorageHandlers();
        Config.processFlags(flags);
    }

    public void applyOption(class_2960 id) {
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        Option option = this.options.get(id);
        if (option != null && option.applyChanges()) {
            flags.addAll(option.getFlags());
        }
        this.flushStorageHandlers();
        Config.processFlags(flags);
    }

    public boolean anyOptionChanged() {
        for (Option option : this.options.values()) {
            if (!option.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void invalidateGlobalRebuildDependents() {
        this.invalidateDependents(this.globalRebuildDependents);
    }

    void notifyStorageWrite(StorageEventHandler handler) {
        this.pendingStorageHandlers.add((Object)handler);
    }

    void flushStorageHandlers() {
        for (StorageEventHandler handler : this.pendingStorageHandlers) {
            handler.afterSave();
        }
        this.pendingStorageHandlers.clear();
    }

    public Option getOption(class_2960 id) {
        return this.options.get(id);
    }

    public ImmutableList<ModOptions> getModOptions() {
        return this.modOptions;
    }

    @Override
    public boolean readBooleanOption(class_2960 id) {
        Option option = this.options.get(id);
        if (option instanceof BooleanOption) {
            BooleanOption booleanOption = (BooleanOption)option;
            return (Boolean)booleanOption.getValidatedValue();
        }
        throw new IllegalArgumentException("Can't read boolean value from option with id " + String.valueOf(id));
    }

    @Override
    public int readIntOption(class_2960 id) {
        Option option = this.options.get(id);
        if (option instanceof IntegerOption) {
            IntegerOption intOption = (IntegerOption)option;
            return (Integer)intOption.getValidatedValue();
        }
        throw new IllegalArgumentException("Can't read int value from option with id " + String.valueOf(id));
    }

    @Override
    public <E extends Enum<E>> E readEnumOption(class_2960 id, Class<E> enumClass) {
        Option option = this.options.get(id);
        if (option instanceof EnumOption) {
            EnumOption enumOption = (EnumOption)option;
            if (enumOption.enumClass != enumClass) {
                throw new IllegalArgumentException("Enum class mismatch for option with id " + String.valueOf(id) + ": requested " + String.valueOf(enumClass) + ", option has " + String.valueOf(enumOption.enumClass));
            }
            return (E)((Enum)enumClass.cast(enumOption.getValidatedValue()));
        }
        throw new IllegalArgumentException("Can't read enum value from option with id " + String.valueOf(id));
    }

    private static void processFlags(Collection<OptionFlag> flags) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
                client.field_1769.method_3279();
            } else if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_UPDATE)) {
                client.field_1769.method_3292();
            }
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.method_24041(((Integer)client.field_1690.method_42563().method_41753()).intValue());
            client.method_1513();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_VIDEOMODE_RELOAD)) {
            client.method_22683().method_4475();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_GAME_RESTART)) {
            Console.instance().logMessage(MessageLevel.WARN, "sodium.console.game_restart", true, 10.0);
        }
    }
}

