/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.OptionBinding;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.api.config.structure.StatefulOptionBuilder;
import net.caffeinemc.mods.sodium.client.config.AnonymousOptionBinding;
import net.caffeinemc.mods.sodium.client.config.builder.OptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.structure.StatefulOption;
import net.caffeinemc.mods.sodium.client.config.value.ConstantValue;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.caffeinemc.mods.sodium.client.config.value.DynamicValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;

abstract class StatefulOptionBuilderImpl<O extends StatefulOption<V>, V>
extends OptionBuilderImpl<O>
implements StatefulOptionBuilder<V> {
    private StorageEventHandler storage;
    private Function<V, class_2561> tooltipProvider;
    private OptionImpact impact;
    private EnumSet<OptionFlag> flags;
    private DependentValue<V> defaultValue;
    private OptionBinding<V> binding;

    StatefulOptionBuilderImpl(class_2960 id) {
        super(id);
    }

    @Override
    void validateData() {
        super.validateData();
        Validate.notNull((Object)this.getStorage(), (String)"Storage handler must be set", (Object[])new Object[0]);
        Validate.notNull(this.getTooltipProvider(), (String)"Tooltip provider must be set", (Object[])new Object[0]);
        Validate.notNull(this.getDefaultValue(), (String)"Default value must be set", (Object[])new Object[0]);
        Validate.notNull(this.getBinding(), (String)"Binding must be set", (Object[])new Object[0]);
    }

    @Override
    Collection<class_2960> getDependencies() {
        Collection<class_2960> dependencies = super.getDependencies();
        dependencies.addAll(this.getDefaultValue().getDependencies());
        return dependencies;
    }

    StorageEventHandler getStorage() {
        return this.getFirstNotNull(this.storage, StatefulOption::getStorage);
    }

    Function<V, class_2561> getTooltipProvider() {
        return this.getFirstNotNull(this.tooltipProvider, StatefulOption::getTooltipProvider);
    }

    OptionImpact getImpact() {
        return this.getFirstNotNull(this.impact, StatefulOption::getImpact);
    }

    EnumSet<OptionFlag> getFlags() {
        return this.getFirstNotNull(this.flags, StatefulOption::getFlags);
    }

    DependentValue<V> getDefaultValue() {
        return this.getFirstNotNull(this.defaultValue, StatefulOption::getDefaultValue);
    }

    OptionBinding<V> getBinding() {
        return this.getFirstNotNull(this.binding, StatefulOption::getBinding);
    }

    @Override
    public StatefulOptionBuilder<V> setStorageHandler(StorageEventHandler storage) {
        Validate.notNull((Object)storage, (String)"Argument must not be null", (Object[])new Object[0]);
        this.storage = storage;
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setTooltip(class_2561 tooltip) {
        Validate.notNull((Object)tooltip, (String)"Argument must not be null", (Object[])new Object[0]);
        this.tooltipProvider = v -> tooltip;
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setTooltip(Function<V, class_2561> tooltip) {
        Validate.notNull(tooltip, (String)"Argument must not be null", (Object[])new Object[0]);
        this.tooltipProvider = tooltip;
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setImpact(OptionImpact impact) {
        Validate.notNull((Object)impact, (String)"Argument must not be null", (Object[])new Object[0]);
        this.impact = impact;
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setFlags(OptionFlag ... flags) {
        if (this.getFlags() == null) {
            this.flags = EnumSet.noneOf(OptionFlag.class);
        }
        Collections.addAll(this.getFlags(), flags);
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setDefaultValue(V value) {
        Validate.notNull(value, (String)"Argument must not be null", (Object[])new Object[0]);
        this.defaultValue = new ConstantValue<V>(value);
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setDefaultProvider(Function<ConfigState, V> provider, class_2960 ... dependencies) {
        Validate.notNull(provider, (String)"Argument must not be null", (Object[])new Object[0]);
        this.defaultValue = new DynamicValue<V>(provider, dependencies);
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setBinding(Consumer<V> save, Supplier<V> load) {
        Validate.notNull(save, (String)"Setter must not be null", (Object[])new Object[0]);
        Validate.notNull(load, (String)"Getter must not be null", (Object[])new Object[0]);
        this.binding = new AnonymousOptionBinding<V>(save, load);
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setBinding(OptionBinding<V> binding) {
        Validate.notNull(binding, (String)"Argument must not be null", (Object[])new Object[0]);
        this.binding = binding;
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setName(class_2561 name) {
        super.setName(name);
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setEnabled(boolean available) {
        super.setEnabled(available);
        return this;
    }

    @Override
    public StatefulOptionBuilder<V> setEnabledProvider(Function<ConfigState, Boolean> provider, class_2960 ... dependencies) {
        super.setEnabledProvider(provider, dependencies);
        return this;
    }
}

