/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import mcp.mobius.waila.api.IRegistryFilter;
import mcp.mobius.waila.util.Log;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jspecify.annotations.Nullable;

public class RegistryFilter<T>
implements IRegistryFilter<T> {
    public static final ThreadLocal<@Nullable class_5455> REGISTRY = ThreadLocal.withInitial(() -> null);
    public static final Set<RegistryFilter<?>> INSTANCES = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private static final Log LOG = Log.create();
    private final class_5321<? extends class_2378<T>> registryKey;
    private final Set<Rule<T>> rules;
    private final ThreadLocal<@Nullable class_2378<T>> registry = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<Set<T>> entries = ThreadLocal.withInitial(Set::of);
    private final ThreadLocal<Boolean> loaded = ThreadLocal.withInitial(() -> true);

    private RegistryFilter(class_5321<? extends class_2378<T>> registry, Set<Rule<T>> rules) {
        this.registryKey = registry;
        this.rules = rules;
        INSTANCES.add(this);
        this.attach();
    }

    public static void attach(@Nullable class_5455 registryAccess) {
        REGISTRY.set(registryAccess);
        INSTANCES.forEach(RegistryFilter::attach);
    }

    public void attach() {
        class_5455 access = REGISTRY.get();
        this.registry.set(access == null ? null : access.method_30530(this.registryKey));
        this.entries.set(Set.of());
        this.loaded.set(false);
    }

    private void load() {
        if (this.loaded.get().booleanValue()) {
            return;
        }
        class_2378 registry = this.registry.get();
        if (registry == null) {
            return;
        }
        Stopwatch stopwatch = null;
        if (LOG.isDebugEnabled()) {
            stopwatch = Stopwatch.createStarted();
            LOG.debug("Attaching registry to filter, id: {}", this.hashCode());
        }
        HashSet entries = new HashSet(this.entries.get().size());
        this.rules.forEach(rule -> registry.method_42017().forEach(holder -> {
            if (rule.predicate.test((class_6880.class_6883<class_6880.class_6883>)holder)) {
                if (rule.negate) {
                    entries.remove(holder.comp_349());
                } else {
                    entries.add(holder.comp_349());
                }
            }
        }));
        this.entries.set(Collections.unmodifiableSet(entries));
        if (stopwatch != null) {
            LOG.debug("Finished in {}ms, {} entries matched", stopwatch.elapsed(TimeUnit.MILLISECONDS), entries.size());
            entries.stream().map(it -> Objects.requireNonNull(registry.method_10221(it)).toString()).sorted().forEach(it -> LOG.debug("\t{}", it));
        }
        this.loaded.set(true);
    }

    @Override
    public Collection<T> getMatches() {
        this.load();
        return this.entries.get();
    }

    @Override
    public boolean matches(T object) {
        this.load();
        return this.entries.get().contains(object);
    }

    private record Rule<T>(boolean negate, Predicate<class_6880.class_6883<T>> predicate) {
    }

    public static class Builder<T>
    implements IRegistryFilter.Builder<T> {
        private final class_5321<? extends class_2378<T>> registryKey;
        private final Set<Rule<T>> rules;
        private final @Nullable Stopwatch stopwatch;

        public Builder(class_5321<? extends class_2378<T>> registryKey) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Start filter for {}", registryKey.method_29177());
                this.stopwatch = Stopwatch.createStarted();
            } else {
                this.stopwatch = null;
            }
            this.registryKey = registryKey;
            this.rules = new LinkedHashSet<Rule<T>>();
        }

        @Override
        public IRegistryFilter.Builder<T> parse(String rule) {
            if (rule.charAt(0) == '!') {
                this.parse0(rule.substring(1), true);
            } else {
                this.parse0(rule, false);
            }
            return this;
        }

        private void parse0(String rule, boolean negate) {
            switch (rule.charAt(0)) {
                case '@': {
                    LOG.debug("\tNegate: {}, Namespace: {}", negate, rule);
                    String namespace = rule.substring(1);
                    this.rules.add(new Rule(negate, it -> it.method_40237().method_29177().method_12836().equals(namespace)));
                    break;
                }
                case '#': {
                    LOG.debug("\tNegate: {}, Tag      : {}", negate, rule);
                    class_2960 tagId = class_2960.method_60654((String)rule.substring(1));
                    class_6862 tag = class_6862.method_40092(this.registryKey, (class_2960)tagId);
                    this.rules.add(new Rule(negate, it -> it.method_40220(tag)));
                    break;
                }
                case '/': {
                    LOG.debug("\tNegate: {}, Regex    : {}", negate, rule);
                    Preconditions.checkArgument((boolean)rule.endsWith("/"), (Object)"Regex filter must also ends with /");
                    Pattern pattern = Pattern.compile(rule.substring(1, rule.length() - 1));
                    this.rules.add(new Rule(negate, it -> pattern.matcher(it.method_40237().method_29177().toString()).matches()));
                    break;
                }
                default: {
                    LOG.debug("\tNegate: {}, ID       : {}", negate, rule);
                    this.rules.add(new Rule(negate, it -> it.method_40226(class_2960.method_60654((String)rule))));
                }
            }
        }

        @Override
        public IRegistryFilter.Builder<T> parse(Iterable<String> rules) {
            rules.forEach(this::parse);
            return this;
        }

        @Override
        public IRegistryFilter.Builder<T> parse(String ... rules) {
            for (String filter : rules) {
                this.parse(filter);
            }
            return this;
        }

        @Override
        public IRegistryFilter<T> build() {
            RegistryFilter<T> res = new RegistryFilter<T>(this.registryKey, this.rules);
            if (this.stopwatch != null) {
                LOG.debug("Finished in {}ms, id: {}", this.stopwatch.elapsed(TimeUnit.MILLISECONDS), res.hashCode());
            }
            return res;
        }
    }
}

