/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.ItemListComponent;
import mcp.mobius.waila.api.component.NamedItemListComponent;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.api.data.ProgressData;
import mcp.mobius.waila.plugin.extra.data.ItemDataImpl;
import mcp.mobius.waila.plugin.extra.data.ProgressDataImpl;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import mcp.mobius.waila.plugin.extra.provider.ProgressProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9326;
import org.jspecify.annotations.Nullable;

public class ItemProvider
extends DataProvider<ItemData, ItemDataImpl> {
    public static final ItemProvider INSTANCE = new ItemProvider();
    private @Nullable ItemData lastData = null;
    private @Nullable ITooltipComponent lastItemsComponent = null;

    protected ItemProvider() {
        super(ItemData.TYPE, ItemDataImpl.CODEC);
    }

    @Override
    protected void registerAdditions(ICommonRegistrar registrar, int priority) {
        registrar.syncedConfig(ItemData.CONFIG_SYNC_NBT, true, false);
        registrar.localConfig(ItemData.CONFIG_DISPLAY_MODE, ItemData.ItemDisplayMode.DYNAMIC);
        registrar.localConfig(ItemData.CONFIG_MAX_HEIGHT, 3);
        registrar.localConfig(ItemData.CONFIG_SORT_BY_COUNT, true);
        registrar.localConfig(ItemData.CONFIG_GRID_MODE_SCALE, 1.0);
    }

    @Override
    protected void appendBody(ITooltip tooltip, IDataReader reader, IPluginConfig config, class_2960 objectId) {
        ProgressDataImpl progress = (ProgressDataImpl)reader.get(ProgressData.TYPE);
        if (progress == null || !progress.hasTick && progress.ratio == 0.0f || progress.hasTick && progress.currentTick == 0 || ProgressProvider.isProgressOnly(progress, config)) {
            super.appendBody(tooltip, reader, config, objectId);
        }
    }

    @Override
    protected void appendBody(ITooltip tooltip, ItemDataImpl data, IPluginConfig config, class_2960 objectId) {
        if (data == this.lastData) {
            if (this.lastItemsComponent != null) {
                tooltip.setLine(ItemData.ID, this.lastItemsComponent);
            }
            return;
        }
        this.lastData = data;
        this.lastItemsComponent = null;
        LinkedHashMap<Object, class_1799> merged = new LinkedHashMap<Object, class_1799>();
        HashMap<class_1792, Set> unique = new HashMap<class_1792, Set>();
        for (class_1799 stack : data.items()) {
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            int count = stack.method_7947();
            if (!data.syncNbt()) {
                if (unique.put(item, Set.of()) != null) {
                    ((class_1799)merged.get(item)).method_7933(count);
                    continue;
                }
                merged.put(item, stack.method_7972());
                continue;
            }
            class_9326 nbt = stack.method_57380();
            if (unique.computeIfAbsent(item, i -> new HashSet()).add(nbt)) {
                merged.put(new ItemWithNbt(item, nbt), stack.method_7972());
                continue;
            }
            ((class_1799)merged.get(new ItemWithNbt(item, nbt))).method_7933(count);
        }
        if (merged.isEmpty()) {
            return;
        }
        Stream<Object> stream = merged.values().stream();
        if (config.getBoolean(ItemData.CONFIG_SORT_BY_COUNT)) {
            stream = stream.sorted(Comparator.comparingInt(class_1799::method_7947).reversed());
        }
        List<class_1799> list = stream.toList();
        int maxHeight = config.getInt(ItemData.CONFIG_MAX_HEIGHT);
        float scale = (float)config.getDouble(ItemData.CONFIG_GRID_MODE_SCALE);
        this.lastItemsComponent = switch ((ItemData.ItemDisplayMode)((Object)config.getEnum(ItemData.CONFIG_DISPLAY_MODE))) {
            default -> throw new MatchException(null, null);
            case ItemData.ItemDisplayMode.DYNAMIC -> {
                if (list.size() <= maxHeight) {
                    yield new NamedItemListComponent(list, maxHeight);
                }
                yield new ItemListComponent(list, maxHeight, scale);
            }
            case ItemData.ItemDisplayMode.GRID -> new ItemListComponent(list, maxHeight, scale);
            case ItemData.ItemDisplayMode.LIST -> new NamedItemListComponent(list, maxHeight);
        };
        tooltip.setLine(ItemData.ID, this.lastItemsComponent);
    }

    private record ItemWithNbt(class_1792 item, class_9326 tag) {
    }
}

