/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud.theme;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;

public class ThemeType<T extends ITheme>
implements IThemeType<T>,
IThemeType.Builder<T> {
    private static final Set<String> INVALID_NAMES = Set.of("id", "type");
    private static final String INVALID_NAME_ERROR_MSG = "Theme type contains one of invalid property name [" + String.join((CharSequence)", ", INVALID_NAMES) + "]";
    public final Class<T> clazz;
    public final LinkedHashMap<String, Property<?, ?>> properties = new LinkedHashMap();
    private final MethodHandles.Lookup lookup;
    private boolean built = false;

    public ThemeType(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.lookup = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public T create(Map<String, Object> attr) {
        try {
            ITheme theme = (ITheme)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.properties.forEach((key, prop) -> prop.set(theme, TypeUtil.uncheckedCast(attr.computeIfAbsent((String)key, k -> Objects.requireNonNull(prop.defaultValue)))));
            return (T)theme;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2960 getId() {
        return Objects.requireNonNull((class_2960)Registrar.get().themeTypes.inverse().get((Object)this));
    }

    private <V, C> ThemeType<T> property(String name, Class<V> type, V exampleValue, @Nullable C context) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        Preconditions.checkArgument((!INVALID_NAMES.contains(name) ? 1 : 0) != 0, (Object)INVALID_NAME_ERROR_MSG);
        this.properties.put(name, new Property<V, C>(name, type, exampleValue, context));
        return this;
    }

    @Override
    public IThemeType.Builder<T> property(String name, int defaultValue) {
        return this.property(name, IntFormat.DECIMAL, defaultValue);
    }

    @Override
    public IThemeType.Builder<T> property(String name, IntFormat format, int defaultValue) {
        return this.property(name, Integer.TYPE, defaultValue, format);
    }

    @Override
    public IThemeType.Builder<T> property(String name, boolean defaultValue) {
        return this.property(name, Boolean.TYPE, defaultValue, null);
    }

    @Override
    public IThemeType.Builder<T> property(String name, double defaultValue) {
        return this.property(name, Double.TYPE, defaultValue, null);
    }

    @Override
    public IThemeType.Builder<T> property(String name, String defaultValue) {
        return this.property(name, String.class, defaultValue, null);
    }

    @Override
    public <E extends Enum<E>> IThemeType.Builder<T> property(String name, E defaultValue) {
        return this.property(name, defaultValue.getDeclaringClass(), defaultValue, null);
    }

    @Override
    public IThemeType<T> build() {
        this.built = true;
        return this;
    }

    public final class Property<V, C> {
        public final String name;
        public final Class<V> type;
        public final V defaultValue;
        public final @Nullable C context;
        private final VarHandle handle;

        public Property(String name, Class<V> type, @Nullable V defaultValue, C context) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
            this.context = context;
            try {
                this.handle = ThemeType.this.lookup.findVarHandle(ThemeType.this.clazz, name, type);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        public V get(Object theme) {
            return (V)TypeUtil.uncheckedCast(this.handle.get(theme));
        }

        public void set(Object theme, Object value) {
            this.handle.set(theme, value);
        }

        public String getTlKey() {
            class_2960 typeId = ThemeType.this.getId();
            return "theme.waila.plugin_" + typeId.method_12836() + "." + typeId.method_12832() + "." + this.name;
        }
    }
}

