/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.debug;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.gui.hud.TooltipPosition;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.registry.InstanceRegistry;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.Log;
import org.jspecify.annotations.Nullable;

public class DumpGenerator {
    private static final Log LOG = Log.create();
    public static final String LOCAL = "local_dump";
    public static final String SERVER = "server_dump";
    public static final String CLIENT = "client_dump";
    public static final Map<String, String> VERSIONS = new LinkedHashMap<String, String>();

    public static @Nullable Path generate(String name) {
        Path path;
        Path path2 = Waila.GAME_DIR.resolve(".waila/" + name + ".md").toAbsolutePath();
        path2.getParent().toFile().mkdirs();
        StringBuilder builder = new StringBuilder("# Waila Dump");
        Registrar registrar = Registrar.get();
        builder.append("\n## Versions");
        builder.append("\n| Dependency | Version |");
        builder.append("\n| - | - |");
        VERSIONS.forEach((k, v) -> builder.append("\n| ").append((String)k).append(" | `").append((String)v).append("` |"));
        builder.append("\n## Plugins");
        builder.append("\n| Plugin ID | Plugin Class | Mod Name | Mod Version |");
        builder.append("\n| - | - | - | - |");
        PluginInfo.getAll().stream().sorted(Comparator.comparing(IPluginInfo::getPluginId)).forEachOrdered(plugin -> builder.append("\n| `").append(plugin.getPluginId()).append("` | `").append(plugin.getInitializer().getClass().getCanonicalName()).append("` | ").append(plugin.getModInfo().getName()).append(" | `").append(plugin.getModInfo().getVersion()).append("` |"));
        builder.append("\n## Block");
        DumpGenerator.createSection(builder, "Override Providers", registrar.blockOverride);
        DumpGenerator.createSection(builder, "Display Icon Providers", registrar.blockIcon);
        DumpGenerator.createSection(builder, "Head Providers", registrar.blockComponent.get((Object)TooltipPosition.HEAD));
        DumpGenerator.createSection(builder, "Body Providers", registrar.blockComponent.get((Object)TooltipPosition.BODY));
        DumpGenerator.createSection(builder, "Tail Providers", registrar.blockComponent.get((Object)TooltipPosition.TAIL));
        DumpGenerator.createSection(builder, "Data Providers", registrar.blockData);
        builder.append("\n## Entity");
        DumpGenerator.createSection(builder, "Override Providers", registrar.entityOverride);
        DumpGenerator.createSection(builder, "Display Icon Providers", registrar.entityIcon);
        DumpGenerator.createSection(builder, "Head Providers", registrar.entityComponent.get((Object)TooltipPosition.HEAD));
        DumpGenerator.createSection(builder, "Body Providers", registrar.entityComponent.get((Object)TooltipPosition.BODY));
        DumpGenerator.createSection(builder, "Tail Providers", registrar.entityComponent.get((Object)TooltipPosition.TAIL));
        DumpGenerator.createSection(builder, "Data Providers", registrar.entityData);
        FileWriter writer = new FileWriter(path2.toFile());
        try {
            writer.write(builder.toString());
            LOG.info("Created debug dump at {}", path2);
            path = path2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        writer.close();
        return path;
    }

    private static <T> void createSection(StringBuilder builder, String subsection, InstanceRegistry<T> registry) {
        Map<Class<?>, Set<InstanceRegistry.EntryImpl<T>>> map = registry.getMap();
        if (map.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        builder.append("\n| Target Class | Provider Class |");
        builder.append("\n| - | - |");
        map.forEach((k, v) -> {
            if (!v.isEmpty()) {
                builder.append("\n| `").append(k.getName()).append("` ");
                int[] i = new int[]{0};
                v.stream().map(o -> o.instance().getClass().getName()).distinct().sorted(String::compareToIgnoreCase).forEachOrdered(s -> {
                    if (i[0] == 0) {
                        builder.append("| `").append((String)s).append("` |");
                    } else {
                        builder.append("\n| | `").append((String)s).append("` |");
                    }
                    i[0] = i[0] + 1;
                });
            }
        });
        builder.append("\n\n");
    }
}

