/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;

@ApiSide.ClientOnly
public class HealthComponent
implements ITooltipComponent {
    private static final class_2960 SPRITE_CONTAINER = class_2960.method_60656((String)"hud/heart/container");
    private static final class_2960 SPRITE_NORMAL_FULL = class_2960.method_60656((String)"hud/heart/full");
    private static final class_2960 SPRITE_NORMAL_HALF = class_2960.method_60656((String)"hud/heart/half");
    private static final class_2960 SPRITE_ABSORBING_FULL = class_2960.method_60656((String)"hud/heart/absorbing_full");
    private static final class_2960 SPRITE_ABSORBING_HALF = class_2960.method_60656((String)"hud/heart/absorbing_half");
    private final int health;
    private final int iconCount;
    private final int lineWidth;
    private final boolean absorption;

    public HealthComponent(float health, float maxHealth, int maxPerLine, boolean absorption) {
        this.health = class_3532.method_15386((float)health);
        this.iconCount = class_3532.method_38788((int)class_3532.method_15386((float)Math.max(health, maxHealth)), (int)2);
        this.lineWidth = Math.min(this.iconCount, maxPerLine);
        this.absorption = absorption;
    }

    @Override
    public int getWidth() {
        return this.lineWidth * 8 + 1;
    }

    @Override
    public int getHeight() {
        return class_3532.method_38788((int)this.iconCount, (int)this.lineWidth) * 3 + 6;
    }

    @Override
    public void render(class_332 ctx, int x, int y, class_9779 delta) {
        int filled = this.health / 2 - 1;
        int half = filled + this.health % 2;
        for (int i = this.iconCount - 1; i >= 0; --i) {
            int ix = x + i % this.lineWidth * 8;
            int iy = y + i / this.lineWidth * 3;
            ctx.method_52706(class_10799.field_56883, SPRITE_CONTAINER, ix, iy, 9, 9);
            if (i <= filled) {
                ctx.method_52706(class_10799.field_56883, this.absorption ? SPRITE_ABSORBING_FULL : SPRITE_NORMAL_FULL, ix, iy, 9, 9);
                continue;
            }
            if (i != half) continue;
            ctx.method_52706(class_10799.field_56883, this.absorption ? SPRITE_ABSORBING_HALF : SPRITE_NORMAL_HALF, ix, iy, 9, 9);
        }
    }
}

